#Supercars program
#Example solution
#Programmed by Mr A Simpson
#Date: 10/11/2022
# ---------------------------------------------

# 1 Read pupil details from file
def readFromFile(superCars):
    counter = 0

    with open("Supercars.csv") as readfile:
        line = readfile.readline().rstrip("\n")
        while line:
            items = line.split(",")
            superCars[counter].name = items[0]
            superCars[counter].topSpeed = int(items[1])
            superCars[counter].engineSize = float(items[2])
            superCars[counter].bhp = int(items[3])

            line = readfile.readline().rstrip("\n")

            counter += 1

# -------------------------------------------

# 2. Find the Supercar with the fastest topSpeed.
def findMaxCar(superCars,fastestCar,fastestSpeed):
    #initialise local variables
    maximum = 0
    maxPos = 0

    #set first position of list to maximum
    maximum = superCars[0].topSpeed

    #loop through each position from second item
    for counter in range(1, len(superCars)):
        if superCars[counter].topSpeed > maximum:
            maximum = superCars[counter].topSpeed
            maxPos = counter
    fastestCar = superCars[maxPos].name
    fastestSpeed = maximum

    return fastestCar, fastestSpeed


# -----------------------------------------------
# 3 Count the number of Supercars with a brake horse power (BHP) > 600 inclusive
def countOccurences(superCars, noOfBHP):

    for counter in range(0, len(superCars)):
        if superCars[counter].bhp > 600:
            noOfBHP += 1
    return noOfBHP

# ---------------------------------------------

# 4. Allow the user to search for a car name and return engine size. Use LAFerrari to test.
def linearSearch(superCars):
    found = False
    target = ""
    
    print("-----Engine Size Checker ------")
    target = input("What car would you like to search for?")
    for counter in range(0,len(superCars)):
        if superCars[counter].name == target:
            found = True
            position = counter

    if found == True:
        print(target, "has an engine size of", superCars[position].engineSize)
    else:
        print("Car was not found")
# ---------------------------------------------

# 5 Display results to Screen
def DisplayResults(fastestCar, fastestSpeed, noOfBHP):

    print("-----------------------------------------")
    print("The fastest car is the ", fastestCar, "with a top speed of", fastestSpeed)
    print("The number of cars over 600 BHP is ", noOfBHP)

# -----------------------------------------------
# Main Program

#Create Record Structure and declare variables
from dataclasses import dataclass
@dataclass
class carData:
    name: str = ""
    topSpeed: str = ""
    engineSize: str = ""
    bhp: int = 0

#Create Array of Records
superCars = [carData() for x in range(29)]

fastestCar = ""
fastestSpeed = 0
noOfBHP = 0

#------- Call functions/subprograms and pass parameters -------------

# 1. Call funtion to read in and store values from SuperCars.csv
readFromFile(superCars)

# 2. Find the Supercar with the fastest topSpeed.
fastestCar,fastestSpeed = findMaxCar(superCars,fastestCar, fastestSpeed)

# 3. Count the number of Supercars with a brake horse power (BHP) > 600 inclusive
noOfBHP = countOccurences(superCars, noOfBHP)

# 4. Allow the user to search for a car name and return engine size. 
#    Use LAFerrari to test (case sensitive)
searchEngine = linearSearch(superCars)

# 5. Display results to screen
DisplayResults(fastestCar, fastestSpeed, noOfBHP)



